#!/usr/local/bin/perl
# 
# oc4jctl_common.pm
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oc4jctl_common.pm - OC4J Control Action Script Common Library Module
#
#    DESCRIPTION
#      oc4jctl_common.pm - Common library module for OC4J Control
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jgrout      01/31/12 - Created

package oc4jctl_common;

use strict;
use warnings;

our $VERSION = '1';

use English;

# Perl status codes
use constant {
  SUCC_CODE => 0 ,
  FAIL_CODE => 1 ,
  ERROR_PID => -1 ,
  NULL_PID  => -2
};

# Agent status codes
use constant {
  STATE_ONLINE => 0 ,
  STATE_OFFLINE => 1 ,
  STATE_UNKNOWN => 3 ,
  STATE_FAILED => 5
};

our $debug_out_set;

our (@ISA, @EXPORT);

# Export in a BEGIN block to avoid compilation failure

BEGIN {
  require Exporter;
  @ISA = qw(Exporter);

  my @exp_const = qw(SUCC_CODE FAIL_CODE ERROR_PID NULL_PID
                     STATE_ONLINE STATE_OFFLINE STATE_UNKNOWN STATE_FAILED
                    );

  my @exp_func = qw(debug_out set_debug_out unset_debug_out
                   );

  my @exp = (@exp_const, @exp_func);
  @EXPORT  = @exp;
}

sub set_debug_out()
{
  $debug_out_set = 1;
}

sub unset_debug_out()
{
  $debug_out_set = 0;
}

sub debug_out
#---------------------------------------------------------------------
# Function: Print debugging list if set_debug_out has been called
#
# Args    : Debugging list to print
#
# Returns : None
#---------------------------------------------------------------------
{
  if ($debug_out_set == 1)
  {
    print STDOUT "[oc4jctl debug]";
    foreach (@_)
    {
      print STDOUT " ", $_;
    }
    print STDOUT "\n";
  }
}

1;
